


import { DateTime } from "luxon";

export default function safeParseTime(
  timeStr: string | undefined,
  format: string,
  zone: string
): DateTime | null {
  if (typeof timeStr === "string" && timeStr.trim()) {
    const parsed = DateTime.fromFormat(timeStr, format, { zone });
    if (parsed.isValid) {
      return parsed;
    } else {
      console.error("Luxon parse error:", parsed.invalidExplanation);
    }
  } else {
    console.warn("Invalid time string");
  }
  return null; // No fallback to DateTime.now()
}
