export function truncateDescription(description: any) {
  return description?.length > 120
    ? description?.substring(0, 120) + "..."
    : description;
}
export function truncateLocation(description: any) {
  return description?.length > 14
    ? description?.substring(0, 14) + "."
    : description;
}
export function truncateTitle(description: any) {
  return description?.length > 70
    ? description?.substring(0, 70) + "."
    : description;
}

export const capitalizeFirstLetter = (word: string): string => {
  return word.charAt(0).toUpperCase() + word.slice(1).toLowerCase();
};
export function truncateDescriptionListing(description: any) {
  return description?.length > 120
    ? description?.substring(0, 400) + "..."
    : description;
}
export function truncateDescriptionData(description: string | null | undefined): string {
  if (typeof description !== "string") return "";
  return description.length > 20 ? `${description.substring(0, 20)}...` : description;
}


// Currency Formatter
export function formatCurrencyUSD(
  amount: string | number | undefined | null
): string {
  if (amount === undefined || amount === null || isNaN(Number(amount)))
    return "$0.00";
  return `$${Number(amount).toLocaleString("en-US", {
    minimumFractionDigits: 2,
    maximumFractionDigits: 2,
  })}`;
}

export const calculateHoursDifference = (
  startDateTime: string,
  endDateTime: string
): number => {
  if (!startDateTime || !endDateTime) return 0;

  const fixDateFormat = (dateStr: string) => {
    if (dateStr.includes(" ") && !dateStr.includes("T")) {
      return dateStr.replace(" ", "T");
    }
    return dateStr;
  };

  const startDate = new Date(fixDateFormat(startDateTime));
  const endDate = new Date(fixDateFormat(endDateTime));

  if (isNaN(startDate.getTime()) || isNaN(endDate.getTime())) {
    // console.error("Invalid date format in calculateHoursDifference", {
    //   startDateTime,
    //   endDateTime,
    // });
    return 0;
  }

  const diffInMs = endDate.getTime() - startDate.getTime(); // Difference in milliseconds
  const diffInHours = diffInMs / (1000 * 60 * 60); // Convert to hours

  return diffInHours;
};
