
import { createSlice, } from '@reduxjs/toolkit';
import { unlockPriorityBids } from '../api/api';

interface NewOrderState {
    unlockdata: any;
    loading: boolean;
    error: string | null;
}

const initialState: NewOrderState = {
    unlockdata: [],
    loading: false,
    error: null,
};

const UnlockSlice = createSlice({
    name: 'UnlockSlice',
    initialState,
    reducers: {},
    extraReducers: (builder) => {
        builder
            .addCase(unlockPriorityBids.pending, (state) => {
                state.loading = true;
                state.error = null;
            })
            .addCase(unlockPriorityBids.fulfilled, (state, action) => {
                state.loading = false;
                state.unlockdata = action.payload; // whole response
            })
      .addCase(unlockPriorityBids.rejected, (state, action) => {
                state.loading = false;
                state.error = action.payload as string;
            });
},
});

export default UnlockSlice.reducer;
