import { createSlice } from "@reduxjs/toolkit";
import { recommendData } from "../api/api";

interface AuctionState {
    recommendListing : any;
    loading: boolean;
    error : string | null;
}

const initialState : AuctionState = {
    recommendListing: [],
    loading: false,
    error: null,
}

const recommendSlice = createSlice({
    name: 'auction',
    initialState,
    reducers: {},
    extraReducers: (builder) => {
      builder
        .addCase(recommendData.pending, (state) => {
          state.loading = true;
          state.error = null;
        })
        .addCase(recommendData.fulfilled, (state, action) => {
          state.loading = false;
          state.recommendListing = action.payload;
        })
        .addCase(recommendData.rejected, (state, action) => {
          state.loading = false;
          state.error = action.error.message || 'Failed to fetch auction listing';
        });
    },
  })

export default recommendSlice.reducer
