
import { createSlice,  } from '@reduxjs/toolkit';
import { allOrders } from '../api/api';

interface NewOrderState {
  data: any; // Adjust type as needed
  loading: boolean;
  error: string | null;
}

const initialState: NewOrderState = {
  data: [],
  loading: false,
  error: null,
};

const OrdersSlice = createSlice({
  name: 'orders',
  initialState,
  reducers: {},
  extraReducers: (builder) => {
    builder
      .addCase(allOrders.pending, (state) => {
        state.loading = true;
        state.error = null;
      })
      .addCase(allOrders.fulfilled, (state, action) => {
        state.loading = false;
        state.data = action.payload;
      })
      .addCase(allOrders.rejected, (state, action) => {
        state.loading = false;
        state.error = action.payload as string;
      });
  },
});

export default OrdersSlice.reducer;
