
import { createSlice,  } from '@reduxjs/toolkit';
import {ongoingBids} from '../api/api';

interface NewOrderState {
  ongoingData: any; 
  loading: boolean;
  error: string | null;
}

const initialState: NewOrderState = {
    ongoingData: [],
  loading: false,
  error: null,
};

const OngoingSlice = createSlice({
  name: 'ongoingBidsData',
  initialState,
  reducers: {},
  extraReducers: (builder) => {
    builder

      .addCase(ongoingBids.pending, (state) => {
        state.loading = true;
        state.error = null;
      })
      .addCase(ongoingBids.fulfilled, (state, action) => {
        state.loading = false;
        state.ongoingData = action.payload;
      })
      .addCase(ongoingBids.rejected, (state, action) => {
        state.loading = false;
        state.error = action.payload as string;
      })

    
  },
});

export default OngoingSlice.reducer;