import { createSlice } from "@reduxjs/toolkit";
import { viewPrice } from "../api/api";

interface SellerState {
  viewPrice: any;
  loading: boolean;
  error: string | null;
}

const initialState: SellerState = {
  viewPrice: null,
  loading: false,
  error: null,
};

const sellerSlice = createSlice({
  name: "seller",
  initialState,
  reducers: {},
  extraReducers: (builder) => {
    builder
      .addCase(viewPrice.pending, (state) => {
        state.loading = true;
        state.error = null;
      })
      .addCase(viewPrice.fulfilled, (state, action) => {
        state.loading = false;
        state.viewPrice  = action.payload;
      })
      .addCase(viewPrice.rejected, (state, action) => {
        state.loading = false;
        state.error = action.payload as string;
      });
  },
});

export default sellerSlice.reducer;
