
import { createSlice } from '@reduxjs/toolkit';
import { homeContent } from '../api/api'; 

interface categoryState {
 homedata: any;
  loading: boolean;
  error: string | null;
}

const initialState: categoryState = {
  homedata: [],
  loading: false,
  error: null,
};

const homeSlice = createSlice({
  name: 'homedata',
  initialState,
  reducers: {},
  extraReducers: (builder) => {
    builder
      .addCase(homeContent.pending, (state) => {
        state.loading = true;
        state.error = null;
      })
      .addCase(homeContent.fulfilled, (state, action) => {
        state.loading = false;
        state.homedata = action.payload;
      })
      .addCase(homeContent.rejected, (state, action) => {
        state.loading = false;
        state.error = action.error.message || 'Failed to fetch search listing';
      });
  },
});

export default homeSlice.reducer;
