import { createSlice } from "@reduxjs/toolkit";
import { guestListing } from "../api/api";

interface AuctionState {
  guestListingData : any;
    loading: boolean;
    error : string | null;
}


const initialState : AuctionState = {
  guestListingData: [],
    loading: false,
    error: null,
}

const guestSlice = createSlice({
    name: 'auction',
    initialState,
    reducers: {},
    extraReducers: (builder) => {
      builder
        .addCase(guestListing.pending, (state) => {
          state.loading = true;
          state.error = null;
        })
        .addCase(guestListing.fulfilled, (state, action) => {
          state.loading = false;
          state.guestListingData = action.payload;
        })
        .addCase(guestListing.rejected, (state, action) => {
          state.loading = false;
          state.error = action.error.message || 'Failed to fetch auction listing';
        });
    },
  })

export default guestSlice.reducer
