import { createSlice, PayloadAction } from '@reduxjs/toolkit';
import { editSeller } from '../api/api'; // Adjust the path accordingly

interface EditSellerState {
  seller: any; // Adjust type according to your seller data structure
  loading: boolean;
  error: string | null;
}

const initialState: EditSellerState = {
  seller: null,
  loading: false,
  error: null,
};

const editSellerSlice = createSlice({
  name: 'editSeller',
  initialState,
  reducers: {
    // You can add regular synchronous actions here if needed
  },
  extraReducers: (builder) => {
    builder
      .addCase(editSeller.pending, (state) => {
        state.loading = true;
        state.error = null;
      })
      .addCase(editSeller.fulfilled, (state, action: PayloadAction<any>) => {
        state.loading = false;
        state.seller = action.payload;
      })
      .addCase(editSeller.rejected, (state, action) => {
        state.loading = false;
        state.error = action.error.message || 'Failed to fetch seller details';
      });
  },
});

export const selectSeller = (state: any) => state.editSeller.seller; // Adjust selector type according to your state
export const selectEditSellerLoading = (state: any) => state.editSeller.loading;
export const selectEditSellerError = (state: any) => state.editSeller.error;

export default editSellerSlice.reducer;