import { createSlice } from "@reduxjs/toolkit";
import { SavedDrafts } from "../api/api";

interface AuctionState {
  savedDraftListing: any;
  loading: boolean;
  error: string | null;
}

const initialState: AuctionState = {
  savedDraftListing: [],
  loading: false,
  error: null,
};

const savedDraftSlice = createSlice({
  name: "auction",
  initialState,
  reducers: {},
  extraReducers: (builder) => {
    builder
      .addCase(SavedDrafts.pending, (state) => {
        state.loading = true;
        state.error = null;
      })
      .addCase(SavedDrafts.fulfilled, (state, action) => {
        state.loading = false;
        state.savedDraftListing = action.payload;
      })
      .addCase(SavedDrafts.rejected, (state, action) => {
        state.loading = false;
        state.error = action.error.message || "Failed to fetch auction listing";
      });
  },
});

export default savedDraftSlice.reducer;
