
import { createSlice, PayloadAction } from '@reduxjs/toolkit';

interface CurrencyState {
    rates: Record<string, number>;
    lastFetched: string | null;
}

const initialState: CurrencyState = {
    rates: {},
    lastFetched: null,
};

const currencyExchangeRateSlice = createSlice({
    name: 'currencyExchangeRate',
    initialState,
    reducers: {
        setExchangeRates: (
            state,
            action: PayloadAction<{ rates: Record<string, number>; fetchedAt: string }>
        ) => {
            state.rates = action.payload.rates;
            state.lastFetched = action.payload.fetchedAt;
        },
    },
});

export const { setExchangeRates } = currencyExchangeRateSlice.actions;
export default currencyExchangeRateSlice.reducer;
