import { createSlice } from "@reduxjs/toolkit";
import { messageCount, getsIncrement } from "../api/api";

interface CountState {
  countData: any;
  incrementData: any;
  loading: boolean;
  error: string | null;
}

const initialState: CountState = {
  countData: [],
  incrementData: [],
  loading: false,
  error: null,
};

const CountSlice = createSlice({
  name: "orders",
  initialState,
  reducers: {},
  extraReducers: (builder) => {
    builder
      .addCase(messageCount.pending, (state) => {
        state.loading = true;
        state.error = null;
      })
      .addCase(messageCount.fulfilled, (state, action) => {
        state.loading = false;
        state.countData = action.payload;
      })
      .addCase(messageCount.rejected, (state, action) => {
        state.loading = false;
        state.error = action.payload as string;
      })
      
      .addCase(getsIncrement.pending, (state) => {
        state.loading = true;
        state.error = null;
      })
      .addCase(getsIncrement.fulfilled, (state, action) => {
        state.loading = false;
        state.incrementData = action.payload;
      })
      .addCase(getsIncrement.rejected, (state, action) => {
        state.loading = false;
        state.error = action.payload as string;
      });
  },
});

export default CountSlice.reducer;
