
import { createSlice, PayloadAction } from '@reduxjs/toolkit';
import {conversation} from '../api/api'

// Define the initial state for the slice
interface ConversationState {
  messages: any; 
  loading: boolean;
  error: string | null;
}

const initialState: ConversationState = {
  messages: [],
  loading: false,
  error: null,
};


// Create the slice
const conversationSlice = createSlice({
  name: 'conversation',
  initialState,
  reducers: {
    // Add any additional reducers if needed
  },
  extraReducers: (builder) => {
    builder
      .addCase(conversation.pending, (state) => {
        state.loading = true;
        state.error = null;
      })
      .addCase(conversation.fulfilled, (state, action: PayloadAction<any[]>) => {
        state.loading = false;
        state.messages = action.payload;
      })
      .addCase(conversation.rejected, (state, action) => {
        state.loading = false;
        state.error = action.error.message || 'Failed to fetch messages';
      });
  },
});

export default conversationSlice.reducer;
