


import { createSlice, PayloadAction } from '@reduxjs/toolkit';

// Define the type for a message
interface Message {
  id: number;
  from_user_id: number;
  to_user_id: number;
  message: string;
  created_at: string;
  updated_at: string;
}

// Define the initial state
interface ChatState {
  messages: Message[];
}

// Create the slice
const chatSlice = createSlice({
  name: 'chat',
  initialState: { messages: [] } as ChatState,
  reducers: {
    addMessage: (state, action: PayloadAction<Message>) => {
      state.messages.push(action.payload);
    },
  },
});

// Export the action
export const { addMessage } = chatSlice.actions;

// Export the reducer
export default chatSlice.reducer;
