
import { createSlice } from '@reduxjs/toolkit';
import { categoryImages } from '../api/api'; 

interface categoryState {
categoryImagesData: any;
  loading: boolean;
  error: string | null;
}

const initialState: categoryState = {
categoryImagesData: [],
  loading: false,
  error: null,
};

const homeSlice = createSlice({
  name: 'categoryImagesData',
  initialState,
  reducers: {},
  extraReducers: (builder) => {
    builder
      .addCase(categoryImages.pending, (state) => {
        state.loading = true;
        state.error = null;
      })
      .addCase(categoryImages.fulfilled, (state, action) => {
        state.loading = false;
        state.categoryImagesData = action.payload;
      })
      .addCase(categoryImages.rejected, (state, action) => {
        state.loading = false;
        state.error = action.error.message || 'Failed to fetch search listing';
      });
  },
});

export default homeSlice.reducer;
