
import { createSlice } from '@reduxjs/toolkit';
import { createBid,  } from '../api/api';

// Define the initial state
interface BidState {
  bids: any[];
  status: 'idle' | 'loading' | 'succeeded' | 'failed';
  error: string | null;
}

const initialState: BidState = {
  bids: [],
  status: 'idle',
  error: null,
};


const bidSlice = createSlice({
  name: 'bids',
  initialState,
  reducers: {
    resetBidStatus: (state) => {
      state.status = 'idle';
      state.error = null;
    }
  },
  extraReducers: (builder) => {
    builder
      .addCase(createBid.pending, (state) => {
        state.status = 'loading';
      })
      .addCase(createBid.fulfilled, (state, action) => {
        state.status = 'succeeded';
        state.bids.push(action.payload);
      })
      .addCase(createBid.rejected, (state, action) => {
        state.status = 'failed';
        state.error = action.payload as string || 'Failed to create bid';
      })
      ;
  },
});

export const { resetBidStatus } = bidSlice.actions;
export default bidSlice.reducer;
