
import { createSlice,  } from '@reduxjs/toolkit';
import { about, terms, polices } from '../api/api';

interface NewOrderState {
  data: any; 
  termsData: any;
  policeData:any;
  loading: boolean;
  error: string | null;
}

const initialState: NewOrderState = {
  data: [],
  termsData: [],
  policeData:[],
  loading: false,
  error: null,
};

const OrdersSlice = createSlice({
  name: 'orders',
  initialState,
  reducers: {},
  extraReducers: (builder) => {
    builder
      .addCase(about.pending, (state) => {
        state.loading = true;
        state.error = null;
      })
      .addCase(about.fulfilled, (state, action) => {
        state.loading = false;
        state.data = action.payload;
      })
      .addCase(about.rejected, (state, action) => {
        state.loading = false;
        state.error = action.payload as string;
      })

      .addCase(terms.pending, (state) => {
        state.loading = true;
        state.error = null;
      })
      .addCase(terms.fulfilled, (state, action) => {
        state.loading = false;
        state.termsData = action.payload;
      })
      .addCase(terms.rejected, (state, action) => {
        state.loading = false;
        state.error = action.payload as string;
      })

      .addCase(polices.pending, (state) => {
        state.loading = true;
        state.error = null;
      })
      .addCase(polices.fulfilled, (state, action) => {
        state.loading = false;
        state.policeData = action.payload;
      })
      .addCase(polices.rejected, (state, action) => {
        state.loading = false;
        state.error = action.payload as string;
      });
  },
});

export default OrdersSlice.reducer;