import { createSlice } from '@reduxjs/toolkit';
import { viewSaller } from '../api/api';


interface SellerState {
  data: any;
  loading: boolean;
  error: string | null;
}

const initialState: SellerState = {
  data: null,
  loading: false,
  error: null,
};

const sellerSlice = createSlice({
  name: 'seller',
  initialState,
  reducers: {
 
  },
  extraReducers: (builder) => {
    builder
      .addCase(viewSaller.pending, (state) => {
        state.loading = true;
        state.error = null;
      })
      .addCase(viewSaller.fulfilled, (state, action) => {
        state.loading = false;
        state.data = action.payload;
      })
      .addCase(viewSaller.rejected, (state, action) => {
        state.loading = false;
        state.error = action.payload as string;
      });
  },
});

export default sellerSlice.reducer;
