import { PayloadAction, createSlice } from "@reduxjs/toolkit";
import { TOKEN_STORAGE_KEY } from "../constants";

interface Token {
  token: string | null;
}

const tokenSlice = createSlice({
  name: "token",
  initialState: {
    token: "",
  } as Token,
  reducers: {
    setToken(state, action: PayloadAction<string>) {
      console.log("check token", action.payload);
      state.token = action.payload;
      localStorage.setItem(TOKEN_STORAGE_KEY, state.token);
    },
    clearToken(state) {
      state.token = null;
      localStorage.removeItem(TOKEN_STORAGE_KEY);
    },
  },
});

export const { setToken, clearToken } = tokenSlice.actions;
export default tokenSlice.reducer;
