import { createSlice } from '@reduxjs/toolkit';
import { searchListing } from '../api/api'; 

interface SearchState {
  searchList: any;
  loading: boolean;
  error: string | null;
}

const initialState: SearchState = {
  searchList: [],
  loading: false,
  error: null,
};

const searchSlice = createSlice({
  name: 'search',
  initialState,
  reducers: {},
  extraReducers: (builder) => {
    builder
      .addCase(searchListing.pending, (state) => {
        state.loading = true;
        state.error = null;
      })
      .addCase(searchListing.fulfilled, (state, action) => {
        state.loading = false;
        state.searchList = action.payload;
      })
      .addCase(searchListing.rejected, (state, action) => {
        state.loading = false;
        state.error = action.error.message || 'Failed to fetch search listing';
      });
  },
});

export default searchSlice.reducer;
