
import { createSlice, PayloadAction } from '@reduxjs/toolkit';
import { profileBuyer, updateProfileBuyer, ratingInfo } from '../api/api';


interface ProfileState {
  buyerProfile: any;
  reatingData: any;
  status: 'idle' | 'loading' | 'succeeded' | 'failed';
  updateStatus: 'idle' | 'loading' | 'succeeded' | 'failed';
  error: string | null;
  loading: boolean;

}

const initialState: ProfileState = {
  buyerProfile: null,
  loading: false,
  reatingData: [],
  status: 'idle',
  updateStatus: 'idle',
  error: null,
};

const profileSlice = createSlice({
  name: 'profile',
  initialState,
  reducers: {},
  extraReducers: (builder) => {
    builder
      .addCase(profileBuyer.pending, (state) => {
        state.status = 'loading';
      })
      .addCase(profileBuyer.fulfilled, (state, action: PayloadAction<any>) => {
        state.status = 'succeeded';
        state.buyerProfile = action.payload;
      })
      .addCase(profileBuyer.rejected, (state, action) => {
        state.status = 'failed';
        state.error = action.error.message || 'Failed to load profile';
      })

      .addCase(updateProfileBuyer.pending, (state) => {
        state.updateStatus = 'loading';
      })
      .addCase(updateProfileBuyer.fulfilled, (state, action: PayloadAction<any>) => {
        state.updateStatus = 'succeeded';
        state.buyerProfile = action.payload; // Update the buyer profile with new data
      })
      .addCase(updateProfileBuyer.rejected, (state, action) => {
        state.updateStatus = 'failed';
        state.error = action.error.message || 'Failed to update profile';
      })

      .addCase(ratingInfo.pending, (state) => {
        state.loading = true;
        state.error = null;
      })
      .addCase(ratingInfo.fulfilled, (state, action) => {
        state.loading = false;
        state.reatingData = action.payload;
      })
      .addCase(ratingInfo.rejected, (state, action) => {
        state.loading = false;
        state.error = action.payload as string;
      });

  },
});

export default profileSlice.reducer;
