import { PayloadAction, createSlice } from "@reduxjs/toolkit";

interface PostAd {
    // id: number;
    title: any | null;
    category: any | null;
    subcategory: any | null;
    categoryId: any | null;
    subcategoryId: any | null;
}

const postAdSlice = createSlice({
    name: 'postad',
    initialState: {
        title: '',
        category: '',
        subcategory: '',
        categoryId: '',
        subcategoryId: ''
    } as PostAd,
    reducers: {
        setValues(state, action: PayloadAction<PostAd>) {
            console.log('p', action.payload);
            state.title = action.payload.title;
            state.category = action.payload.category;
            state.subcategory = action.payload.subcategory;
            state.categoryId = action.payload.categoryId;
            state.subcategoryId = action.payload.subcategoryId;
        },
        // setChild(state, action: PayloadAction<string | null>) {
        //     state.subcategory = action.payload;
        // },
    }
})

export const { setValues } = postAdSlice.actions;
export default postAdSlice.reducer;
