import { createSlice, PayloadAction } from '@reduxjs/toolkit';
import { paymentListing, } from '../api/api';

interface PaymentState {
  paymentList: any;
  loading: boolean;
  error: string | null;
}

const initialState: PaymentState = {
  paymentList: [],
  loading: false,
  error: null,
};

const paymentSlice = createSlice({
  name: 'payment',
  initialState,
  reducers: {
  },
  extraReducers: (builder) => {
    builder
      // Payment Listing
      .addCase(paymentListing.pending, (state) => {
        state.loading = true;
        state.error = null;
      })
      .addCase(paymentListing.fulfilled, (state, action: PayloadAction<any>) => {
        state.loading = false;
        state.paymentList = action.payload;
      })
      .addCase(paymentListing.rejected, (state, action) => {
        state.loading = false;
        state.error = action.error.message || 'Failed to fetch payment listing';
      })
    }
});

// Export the reducer to be used in the store
export default paymentSlice.reducer;
