import { createSlice } from "@reduxjs/toolkit";
import { auctionListing, repostListing, tracklistings } from "../api/api";

interface AuctionState {
  auctionList: any;
  trackListData: any;
  loading: boolean;
  error: string | null;
}

const initialState: AuctionState = {
  auctionList: [],
  trackListData: [],
  loading: false,
  error: null,
};

const auctionSlice = createSlice({
  name: "auction",
  initialState,
  reducers: {},
  extraReducers: (builder) => {
    builder
      .addCase(auctionListing.pending, (state) => {
        state.loading = true;
        state.error = null;
      })
      .addCase(auctionListing.fulfilled, (state, action) => {
        state.loading = false;
        state.auctionList = action.payload;
      })
      .addCase(auctionListing.rejected, (state, action) => {
        state.loading = false;
        state.error = action.error.message || "Failed to fetch auction listing";
      })

      .addCase(tracklistings.pending, (state) => {
        state.loading = true;
        state.error = null;
      })
      .addCase(tracklistings.fulfilled, (state, action) => {
        state.loading = false;
        state.trackListData = action.payload;
      })
      .addCase(tracklistings.rejected, (state, action) => {
        state.loading = false;
        state.error = action.payload as string;
      })
      
      
      .addCase(repostListing.pending, (state) => {
        state.loading = true;
        state.error = null;
      })
      .addCase(repostListing.fulfilled, (state, action) => {
        state.loading = false;
        state.trackListData = action.payload;
      })
      .addCase(repostListing.rejected, (state, action) => {
        state.loading = false;
        state.error = action.payload as string;
      });
  },
});

export default auctionSlice.reducer;
