import Image from "next/image";
import success from "../../../../assets/done.gif";
interface SuccessModalProps {
  isOpen: boolean;
  onClose: () => void;
}

const SuccessModal: React.FC<SuccessModalProps> = ({ isOpen, onClose }) => {
  if (!isOpen) return null;

  return (
    <div className="fixed inset-0 bg-black bg-opacity-30 flex items-center justify-center z-50">
      <div className="bg-white w-[90%] max-w-md rounded-lg shadow-lg p-6 relative">
        <button
          onClick={onClose}
          aria-label="Close modal"
          className="absolute top-4 right-4 text-gray-500 hover:text-gray-700"
        >
          &times;
        </button>
        <div className="text-center">
          {/* GIF Display */}
          <Image
            unoptimized
            src={success} // Replace with your actual GIF URL
            alt="Success GIF"
            className="mx-auto"
            width={200} // Adjust size of the GIF as needed
            height={200} // Adjust size of the GIF as needed
          />
          <h2 className="text-[24px] font-semibold text-[#151D48]">
            Congratulations
          </h2>
          <p className="text-[#454545] text-[18px]">
            You have successfully withdrawal.
          </p>
        </div>
        <button
          onClick={onClose}
          className="mt-4 px-4 py-2 w-full bg-[#F0C666] text-white rounded-md hover:bg-[#0b144d]"
        >
          Close
        </button>
      </div>
    </div>
  );
};

export default SuccessModal;
