// MobileFilterDialog.tsx
import { Dialog, Transition, TransitionChild } from "@headlessui/react";
import { XMarkIcon } from "@heroicons/react/24/outline";
import Image from "next/image";
// import filledarrow from "../../../../assets/filledarrow.svg";
import FilterSection from "./FilterSection";
import filterSvg from "../../../../assets/filters.svg";

interface MobileFilterDialogProps {
  filters: any[];
  mobileFiltersOpen: boolean;
  setMobileFiltersOpen: (open: boolean) => void;
  handleFilterSubmit: (filterKey: string, value: any) => void;
}

export default function MobileFilterDialog({
  filters,
  mobileFiltersOpen,
  setMobileFiltersOpen,
  handleFilterSubmit,
}: MobileFilterDialogProps) {
  return (
    <div className="lg:hidden block">
      <button
        className="flex gap-2 items-center text-lg"
        type="button"
        onClick={() => setMobileFiltersOpen(true)}
      >
        Filter{" "}
        <Image
          unoptimized
          src={filterSvg}
          alt="Filter icon"
          width={20}
          height={20}
          className="w-5 h-5"
        />
      </button>
      <Transition show={mobileFiltersOpen}>
        <Dialog className="relative z-40" onClose={setMobileFiltersOpen}>
          <TransitionChild
            enter="transition-opacity ease-linear duration-300"
            enterFrom="opacity-0"
            enterTo="opacity-100"
            leave="transition-opacity ease-linear duration-300"
            leaveFrom="opacity-100"
            leaveTo="opacity-0"
          >
            <div className="fixed inset-0 bg-black bg-opacity-25" />
          </TransitionChild>

          <div className="fixed inset-0 z-40 flex font-system">
            <TransitionChild
              enter="transition ease-in-out duration-300 transform"
              enterFrom="translate-x-full"
              enterTo="translate-x-0"
              leave="transition ease-in-out duration-300 transform"
              leaveFrom="translate-x-0"
              leaveTo="translate-x-full"
            >
              <Dialog.Panel className="relative ml-auto flex h-full w-full max-w-xs flex-col overflow-y-auto bg-white py-4 pb-12 shadow-xl">
                <div className="flex items-center justify-between px-1">
                  <button
                    type="button"
                    className="flex h-10 w-10 items-center justify-center rounded-md bg-white p-2 text-gray-400"
                    onClick={() => setMobileFiltersOpen(false)}
                  >
                    <XMarkIcon
                      className="h-6 w-6 text-black"
                      aria-hidden="true"
                    />
                  </button>
                </div>

                <form className="mt-4 border-t border-gray-200">
                  {filters.map((section) => (
                    <FilterSection
                      key={section.id}
                      section={section}
                      handleFilterSubmit={handleFilterSubmit}
                    />
                  ))}
                </form>
              </Dialog.Panel>
            </TransitionChild>
          </div>
        </Dialog>
      </Transition>
    </div>
  );
}
