// FilterSection.tsx
import { Disclosure } from "@headlessui/react";
import Image from "next/image";
import filledarrow from "../../../../assets/filledarrow.svg";
// import { useEffect, useState } from "react";

interface FilterSectionProps {
  section: {
    id: string;
    name: string;
    options: Array<{
      value: any;
      label: string;
      checked: boolean;
    }>;
  };
  handleFilterSubmit: (filterKey: string, value: any) => void;
}

export default function FilterSection({
  section,
  handleFilterSubmit,
}: FilterSectionProps) {
  return (
    <Disclosure as="div" className="border-b border-gray-200 py-4">
      {({ open }) => (
        <>
          <h3 className="-my-3 flow-root">
            <Disclosure.Button className="flex w-full items-center justify-between bg-white py-3 text-sm text-gray-400 hover:text-gray-500">
              <span className="font-medium text-gray-900">{section.name}</span>
              <span className="ml-6 flex items-center">
                <Image
                  unoptimized
                  src={filledarrow}
                  width={12}
                  height={12}
                  alt="Arrow icon"
                  className={`transform ${open ? "rotate-180" : ""}`}
                />
              </span>
            </Disclosure.Button>
          </h3>
          <Disclosure.Panel className="p-6">
            <div className="space-y-4">
              {section.options.map((option: any, optionIdx: any) => (
                <div key={option.value} className="flex items-center">
                  <input
                    id={`filter-${section.id}-${optionIdx}`}
                    name={
                      section.id === "location" ? "location" : `${section.id}[]`
                    }
                    value={option.value}
                    type="checkbox" // Changed back to checkbox
                    checked={option.checked}
                    className={`h-4 w-4 rounded border-gray-300 ${
                      section.id === "location"
                        ? "text-blue-600 focus:ring-blue-500"
                        : "text-indigo-600 focus:ring-indigo-500"
                    }`}
                    onChange={() => {
                      // For location, always call handleFilterSubmit to trigger modal
                      if (section.id === "location") {
                        handleFilterSubmit(section.id, option.value);
                      } else {
                        // Normal checkbox behavior for other filters
                        handleFilterSubmit(section.id, option.value);
                      }
                    }}
                  />
                  <label
                    htmlFor={`filter-${section.id}-${optionIdx}`}
                    className="ml-3 text-sm text-gray-600"
                  >
                    {option.label}
                  </label>
                </div>
              ))}
            </div>
          </Disclosure.Panel>
        </>
      )}
    </Disclosure>
  );
}
