import React from "react";
import { convertCurrency } from "../../../../utils/convertCurrency";
import { useSelector } from "react-redux";
interface BidCardProps {
  price: string;
  formatDate: string;
  phone: any;
  selectedCurrency?: any;
  listedCurrency?: any;
  exchangeRates?: any;
}

const BidCard: React.FC<BidCardProps> = ({
  price,
  phone,
  formatDate,
  selectedCurrency,
  listedCurrency,
  exchangeRates,
}) => {
  const currency = useSelector(
    (state: any) => state.CurrencyReducer.selectedCurrency
  );

  return (
    <div className="flex items-start p-3 justify-between rounded-md shadow-sm bg-[#F8F9F9] mt-2 gap-3 w-[330px] sm:w-full">
      <div className="text-start flex gap-2">
        <div className=" text-[#3BAD49] items-start">{phone}</div>
        <div className="text-[#3BAD49] items-start flex flex-col">
          <span>
            {listedCurrency === "USD" ? "US$" : "C$"}{" "}
            {new Intl.NumberFormat("en-US", {
              minimumFractionDigits: 2,
              useGrouping: true,
            }).format(Number(price) || 0)}
          </span>
          {currency != listedCurrency && (
            <span className="text-sm font-semibold text-gray-400">
              ({selectedCurrency === "USD" ? "US$" : "C$"}{" "}
              {convertCurrency(
                parseFloat(price),
                listedCurrency,
                selectedCurrency,
                exchangeRates
              ).toFixed(2)}
              )
            </span>
          )}
        </div>
      </div>
      <div className="text-gray-400">{formatDate}</div>
    </div>
  );
};

export default BidCard;
