"use client";

import dynamic from "next/dynamic";
import React from "react";

const CategoryCarouselInternal = dynamic(
  () => import("./CategoryCarouselInternal"),
  {
    ssr: false,
    loading: () => (
      <div className="text-center py-8">Loading categories...</div>
    ),
  }
);

interface CategoryData {
  id: number;
  parent_id: number | null;
  name: string;
  icon: string;
  created_at: string;
  listing_images?: string[];
}

interface Props {
  categoryData: CategoryData[];
}

export default function CategoryCarousel({ categoryData }: Props) {
  return <CategoryCarouselInternal categoryData={categoryData} />;
}
