// components/AboutClientWrapper.tsx
"use client";

import dynamic from "next/dynamic";
import { Suspense } from "react";

// Dynamic import without `ssr: false`, since this is already a client component
const About = dynamic(() => import("./About"));

export default function AboutClientWrapper() {
  return (
    <Suspense fallback={<div className="text-center py-10">Loading terms...</div>}>
      <About />
    </Suspense>
  );
}
