import Image from "next/image";
import CategoryBackground from "../assets/backgroundCategoryNew.webp";

import { useSelector } from "react-redux";
import type { RootState } from "../store";
import logo from "../assets/reservittlog0.png";
import dynamic from "next/dynamic";
import { useInView } from "react-intersection-observer";

const AnimatedLogoComponent = dynamic(
  () => import("../common/AnimatedLogoComponent")
);

const HeroCategorySlider = dynamic(
  () => import("../common/HeroCategorySlider"),
  {
    loading: () => (
      <div className="h-full w-full text-black flext items-center justify-center">
        Loading...
      </div>
    ),
  }
);

export default function HeroBanner() {
  const { ref: heroCategorySliderRef, inView: heroCategorySliderInView } =
    useInView({
      triggerOnce: true,
      rootMargin: "200px 0px", // Trigger exactly when in view
    });

  const { categories } = useSelector(
    (state: RootState) => state.CategoryListing
  );
  const { homedata } = useSelector(
    (state: RootState) => state.HomeContentReducer
  );
  const settings = homedata?.data?.settings;

  return (
    <>
      <div className="relative w-full font-system lg:block hidden">
        <div>
          {settings && (
            <>
              <div className="relative">
                <Image
                  unoptimized
                  src={settings.banner_image}
                  alt="Banner"
                  width={1920}
                  height={544}
                  className="w-full h-auto"
                  priority
                  quality={75}
                  fetchPriority="high"
                />
                <div className="absolute inset-0 bg-[#001148] opacity-[0.55]"></div>
                <div className="max-w-7xl m-auto flex justify-center">
                  <div className="absolute top-[4%] sm:top-[6%] md:top-[8%] xl:top-[4%] 2xl:top-[14%] text-start text-white w-full">
                    {/* <div className="text-center" ref={animatedLogoComponentRef}>
                      {AnimatedLogoComponentInView ? ( */}
                    <AnimatedLogoComponent />
                    {/* //   ) : null}
                    // </div> */}
                    <p className="text-7xl font-semibold text-center font-inter-tight animate-bounceContinuous mt-[1rem]">
                      {settings.banner_title}
                    </p>
                    <p className="sm:text-6xl mt-5 font-semibold text-center leading-none font-inter-tight animate-bounceContinuous">
                      {settings.banner_subtitle}
                    </p>
                  </div>
                </div>
              </div>
            </>
          )}
        </div>
        {categories?.data?.length > 0 && (
          <div ref={heroCategorySliderRef}>
            {heroCategorySliderInView ? (
              <HeroCategorySlider
                categories={categories?.data}
                CategoryBackgroundSrc={CategoryBackground.src}
              />
            ) : null}
          </div>
        )}
      </div>
      {/* Small screen hero */}
      <div className="relative w-full mt-5 lg:hidden block overflow-hidden">
        {settings && (
          <>
            <div className="relative w-full h-[240px] overflow-hidden">
              {/* Banner image container */}
              <div className="absolute left-1/2 transform -translate-x-1/2 w-screen h-full">
                <Image
                  unoptimized
                  src={settings.banner_image}
                  alt="Banner"
                  fill
                  sizes="100vw"
                  priority
                />
                <div className="absolute inset-0 bg-[#001148] opacity-[0.55] h-full"></div>
              </div>
            </div>

            {/* Content overlay */}
            <div className="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 text-white font-inter-tight w-full px-4">
              <div className="flex justify-center">
                <Image
                  unoptimized
                  src={logo}
                  alt="Logo"
                  width={64}
                  height={64}
                  priority
                />
              </div>
              <p className="text-2xl text-center font-semibold font-inter-tight mt-[0.4rem]">
                {settings.banner_title}
              </p>
              <p className="text-xl font-semibold text-center leading-none font-inter-tight">
                {settings.banner_subtitle}
              </p>
            </div>
          </>
        )}
      </div>
    </>
  );
}
