export function formatDate(input: string): string {
  if (!input) return "";

  let formattedInput = input;

  // Fix format if needed (for Safari)
  if (input.includes(" ") && !input.includes("T")) {
    formattedInput = input.replace(" ", "T");
  }

  const date = new Date(formattedInput);

  if (isNaN(date.getTime())) {
    // console.error("Invalid date format in formatDate:", input);
    return "";
  }

  const year = date.getFullYear();
  const month = String(date.getMonth() + 1).padStart(2, "0"); // months are 0-based
  const day = String(date.getDate()).padStart(2, "0");
  const hours = String(date.getHours()).padStart(2, "0");
  const minutes = String(date.getMinutes()).padStart(2, "0");

  return `${year}-${month}-${day} ${hours}:${minutes}`;
}
