const CommonPopup = ({
  title = "Confirm Deletion",
  description = "Are you sure you want to delete this address?",
  showCancel = true,
  showConfirm = true,
  cancelText = "Cancel",
  confirmText = "Delete",
  onCancel = () => {},
  onConfirm = () => {},
}) => {
  return (
    <div className="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50">
      <div className="bg-white p-6 rounded-lg shadow-xl max-w-sm w-full">
        <h3 className="text-xl font-bold mb-4 text-black text-center">{title}</h3>
        <p className="mb-6 text-gray-600">{description}</p>
        <div className="flex justify-center space-x-4">
          {showCancel && (
            <button
              onClick={onCancel}
              className="px-4 py-2 border text-gray-600 border-gray-300 rounded-md hover:bg-gray-100 transition-colors"
            >
              {cancelText}
            </button>
          )}
          {showConfirm && (
            <button
              onClick={onConfirm}
              className="px-4 py-2 bg-red-600 text-white rounded-md hover:bg-red-700 transition-colors"
            >
              {confirmText}
            </button>
          )}
        </div>
      </div>
    </div>
  );
};

export default CommonPopup;
