import { useState } from "react";

interface CancelOrderPopupProps {
  isOpen: boolean;
  onClose: () => void;
  orderId: string | number;
  onConfirm: (payload: { orderId: string | number; reason: string }) => void;
}

export default function CancelOrderPopup({
  isOpen,
  onClose,
  orderId,
  onConfirm,
}: CancelOrderPopupProps) {
  const [reason, setReason] = useState("");

  if (!isOpen) return null;

  const handleConfirm = () => {
    if (reason.trim()) {
      onConfirm({ orderId, reason }); // ✅ send both
      setReason("");
      onClose();
    }
  };

  return (
    <div className="fixed inset-0 flex items-center justify-center bg-black bg-opacity-50 z-50">
      <div className="bg-white rounded-lg shadow-lg w-96 p-6">
        <h2 className="text-lg font-semibold mb-4">Cancel Order</h2>

        <label className="block text-sm font-medium text-gray-700 mb-2">
          Reason for cancellation:
        </label>
        <textarea
          value={reason}
          onChange={(e) => setReason(e.target.value)}
          placeholder="Enter your reason..."
          className="w-full border border-gray-300 rounded-md p-2 text-sm focus:ring-2 focus:ring-red-500 focus:outline-none"
          rows={3}
        />

        <div className="flex justify-end mt-5 space-x-3">
          <button
            className="px-4 py-2 bg-gray-300 text-gray-700 rounded-md"
            onClick={onClose}
          >
            Close
          </button>
          <button
            className="px-4 py-2 bg-red-600 text-white rounded-md disabled:opacity-50"
            onClick={handleConfirm}
            disabled={!reason.trim()}
          >
            Confirm Cancel
          </button>
        </div>
      </div>
    </div>
  );
}
