"use client";
import { RootState } from "../../../store";
import { useSelector } from "react-redux";
import Results from "../Results";
import { useDispatch } from "react-redux";
import { allOrders } from "../../../api/api";
import { useEffect } from "react";

export default function Listing() {
  const dispatch = useDispatch<any>();

  const { data } = useSelector((state: RootState) => state.OrdersReducer);
  const order = data?.data?.orders;

  useEffect(() => {
    dispatch(allOrders());
  }, [dispatch]);

  return (
    <>
      {order && order.length > 0 ? (
        <Results />
      ) : (
        <div className="bg-yellow-100 mt-20 rounded-lg p-5 space-x-6 mb-4">
          <p className="text-yellow-600 flex justify-center items-center font-semibold">
            No orders found
          </p>
        </div>
      )}
    </>
  );
}
