"use client";

import Image from "next/image";
import React from "react";
import tick from "../../../assets/tick.svg";

const EmailSent: React.FC = () => {
  return (
    <div className="max-w-md mx-auto bg-white mt-10 rounded-xl p-8 px-10 mb-10 text-center">
      <Image
        unoptimized
        src={tick}
        alt="Tick Icon"
        className="mx-auto mb-5"
        height={90}
        width={90}
      />
      <h1 className="text-3xl text-black font-bold mb-4">Email Sent</h1>
      <p className="text-sm text-black font-semibold mb-10">
        An email has been sent to the address you provided. Please follow the
        instructions in the email to change your password.
        <br />
        <br />
        Note that if your account is not registered, you will not receive an
        email.
      </p>
    </div>
  );
};

export default EmailSent;
