import type { NextConfig } from "next";

const nextConfig: NextConfig = {
  reactStrictMode: false,

  images: {
    domains: ["reservitt.com"],
    minimumCacheTTL: 60, // Cache images for 60 seconds
    formats: ["image/webp"], // Serve modern formats
  },
  experimental: {
    optimizePackageImports: ["react-icons"], // Critical for perf
  },
  compress: true, // Enable gzip compression
  swcMinify: true, // Use SWC minifier (faster than Terser)
  productionBrowserSourceMaps: false, // Disable source maps in production
  webpack(config, { isServer, dev }) {
    config.stats = "errors-only"; // 👈 hides webpack warnings

    // Disable source maps in production for client
    if (!dev && !isServer) {
      config.devtool = false;
    }

    return config;
  },

  headers: async () => [
    {
      source: "/(.*)",
      headers: [
        {
          key: "X-DNS-Prefetch-Control",
          value: "on",
        },
      ],
    },
  ],
};

export default nextConfig;
