import forms from "@tailwindcss/forms";
import typography from "@tailwindcss/typography";
import scrollbar from "tailwind-scrollbar";

/** @type {import('tailwindcss').Config} */
export default {
  content: [
    "./pages/**/*.{js,ts,jsx,tsx}",
    "./components/**/*.{js,ts,jsx,tsx}",
    "./app/**/*.{js,ts,jsx,tsx}", // Correctly included if using the /app folder
    "./src/**/*.{js,ts,jsx,tsx}", // Ensure src folder is properly included
  ],
  theme: {
    screens: {
      xs: "240px",
      xsm: "480px",
      sm: "640px",
      md: "768px",
      lg: "1025px",
      xl: "1280px",
      "2xl": "1536px",
      "4xl": "1836px",
    },
    extend: {
      fontFamily: {
        sans: ["Inter", "serif"],
      },
      colors: {
        gold: "#F1C766",
        navy: "#04104E",
        "custom-gray": "#454545",
        customYellow: "rgba(248, 203, 31, 1)",
      },
      width: {
        28: "28rem",
        36: "36rem",
        22: "22rem",
        fill: "-webkit-fill-available",
      },
      height: {
        30: "30rem",
        36: "36rem",
      },
      letterSpacing: {
        "05": "0.5rem",
      },
      skew: {
        "-20": "-20deg",
        20: "20deg",
      },
      animation: {
        bounceContinuous: "bounceContinuous 5s ease-in-out infinite",
      },
      keyframes: {
        bounceContinuous: {
          "0%, 100%": { transform: "translateY(0)" },
          "50%": { transform: "translateY(-10px)" },
        },
      },
    },
  },
  plugins: [forms, typography, scrollbar],
};
