// utils/locationUtils.ts
export const saveLocationToStorage = (location: any) => {
  if (typeof window !== "undefined") {
    localStorage.setItem("location", JSON.stringify(location));
    localStorage.setItem("userSelectedLocation", "true");
  }
};

export const loadLocationFromStorage = () => {
  if (typeof window !== "undefined") {
    const savedLocation = localStorage.getItem("location");
    return savedLocation ? JSON.parse(savedLocation) : null;
  }
  return null;
};