// utils/convertCurrency.ts
export function convertCurrency(
  amount: number,
  from: 'USD' | 'CAD',
  to: 'USD' | 'CAD',
  rates: Record<string, number>
): number {
  if (from === to) return amount;
  const rateFrom = rates[from];
  const rateTo = rates[to];
  if (!rateFrom || !rateTo) return amount;
  return (amount / rateFrom) * rateTo;
}


