import registerReducer from "./slice/RegisterSlice";
import { combineReducers, configureStore } from "@reduxjs/toolkit";
import {
    persistReducer,
    FLUSH,
    REHYDRATE,
    PAUSE,
    PERSIST,
    PURGE,
    REGISTER,
} from "redux-persist";
import storage from "redux-persist/lib/storage";
import { persistStore } from "redux-persist";

import loginReducer from "./slice/LoginSlice";
import editReducer from "./slice/EditProfileSlice";
import tokenReducer from "./slice/TokenSlice";
import postAdReducer from "./slice/PostAdSlice";
import imageReducer from "./slice/ImageSlice";
import sellerListDataReducer from "./slice/SellerListSlice";
import locationReducer from "./slice/LocationSlice";
import profileReducer from "./slice/ProfileSlice";
import SallerProfileReducer from "./slice/SallerProfileSlice";
import AllListingReducer from "./slice/AllListing";
import searchReducer from "./slice/SearchListingSlice";
import viewListingReducer from "./slice/ViewListingSlice";
import CategoryListing from "./slice/categorySlice";
import ReviewReducer from "./slice/reviewSlice";
import ViewSeller from "./slice/ViewSellerSlice";
import StoreListing from "./slice/StoreListing";
import PaymentReducer from "./slice/PaymentSlice";
import PaymentFailedReducer from "./slice/PaymentFailedSlice";
import DeleteListingReducer from "./slice/DeleteSlice";
import BidReducer from "./slice/bidSlice";
import AddressReducer from "./slice/addressSlice";
import OrdersReducer from "./slice/ordersSlice";
import OrderTrackReducer from "./slice/trackOrderSlice";
import SellerOrdersReducer from "./slice/SellerOrderSlice";
import WishlistReducer from "./slice/WishlistSlice";
import AllWishlistReducer from "./slice/AddWishlistSlice";
import HomeContentReducer from "./slice/homeContent";
import MessageReducer from "./slice/messageSlice";
import ConversationReducer from "./slice/conversationSlice";
import EditDetailReducer from "./slice/editSlice";
import EditAddressReducer from "./slice/addressEditSlice";
import ChatReducer from "./slice/chatSlice";
import WalletReducer from "./slice/walletSlice";
import GuestReducer from "./slice/guestListingSlice";
import ViewPriceReducer from "./slice/listingPriceSlice";
import FilterReducer from "./slice/allFilterSlice";
import TicketsReducer from "./slice/ticketsSlice";
import RecommendSlice from "./slice/recommendSlice";
import OrderStatusReducer from "./slice/orderStatusSlice";
import AboutReducer from "./slice/aboutSlice";
import CategoryImagesReducer from "./slice/categoryImagesSlice";
import StateLocationReducer from "./slice/stateSlice";
import IpAddressReducer from "./slice/IpAddressSlice";
import DraftReducer from "./slice/draftsSlice";
import NotificationReducer from "./slice/notificationSlice"
import PriorityReducer from "./slice/priorityBidsSlice"
import CurrencyReducer from "./slice/currencySlice"
import OnGoingReducer from "./slice/OngoingSlice"
import MessageCountReducer from "./slice/countSlice"
import CurrencyExchangeRateReducer from "./slice/currencyExchangeRateSlice"
import BidsHistoryReducer from "./slice/bidsHistorySlice"
import OnGoingBidsReducer from "./slice/ongoingBidsSlice"
import unlockReducer from "./slice/unlockSlice"
import viewListingPriorityReducer from "./slice/listingSlice";
const persistConfig = {
    key: "root",
    storage,
    whitelist: [
        "loginReducer",
        "registerReducer",
        "tokenReducer",
        "editReducer",
        "postAdReducer",
        "imageReducer",
        "sellerListDataReducer",
        "locationReducer",
        "profileReducer",
        "SallerProfileReducer",
        "AllListingReducer",
        "searchReducer",
        "viewListingReducer",
        "CategoryListing",
        "ReviewReducer",
        "ViewSeller",
        "StoreListing",
        "PaymentReducer",
        "PaymentFailedReducer",
        "DeleteListingReducer",
        "BidReducer",
        "AddressReducer",
        "OrdersReducer",
        "OrderTrackReducer",
        "SellerOrdersReducer",
        "WishlistReducer",
        "AllWishlistReducer",
        "HomeContentReducer",
        "MessageReducer",
        "ConversationReducer",
        "EditDetailReducer",
        "EditAddressReducer",
        "ChatReducer",
        "CashOutReducer",
        "WalletReducer",
        "GuestReducer",
        "ViewPriceReducer",
        "FilterReducer",
        "TicketsReducer",
        "RecommendReducer",
        "OrderStatusReducer",
        "AboutReducer",
        "CategoryImagesReducer",
        "StateLocationReducer",
        "IpAddressReducer",
        "DraftReducer",
        "NotificationReducer",
        "PriorityReducer",
        "CurrencyReducer",
        "OnGoingReducer",
        "MessageCountReducer",
        "CurrencyExchangeRateReducer",
        "BidsHistoryReducer",
        "OnGoingBidsReducer",
        "unlockReducer",
        "viewListingPriorityReducer",
    ],
};

const rootReducer = combineReducers({
    registerReducer: registerReducer,
    loginReducer: loginReducer,
    editReducer: editReducer,
    tokenReducer: tokenReducer,
    // authReducer: authReducer,
    postAdReducer: postAdReducer,
    imageReducer: imageReducer,
    sellerListDataReducer: sellerListDataReducer,
    locationReducer: locationReducer,
    profileReducer: profileReducer,
    SallerProfileReducer: SallerProfileReducer,
    AllListingReducer: AllListingReducer,
    searchReducer: searchReducer,
    viewListingReducer: viewListingReducer,
    CategoryListing: CategoryListing,
    ReviewReducer: ReviewReducer,
    ViewSeller: ViewSeller,
    StoreListing: StoreListing,
    PaymentReducer: PaymentReducer,
    PaymentFailedReducer: PaymentFailedReducer,
    DeleteListingReducer: DeleteListingReducer,
    BidReducer: BidReducer,
    AddressReducer: AddressReducer,
    OrdersReducer: OrdersReducer,
    OrderTrackReducer: OrderTrackReducer,
    SellerOrdersReducer: SellerOrdersReducer,
    WishlistReducer: WishlistReducer,
    AllWishlistReducer: AllWishlistReducer,
    HomeContentReducer: HomeContentReducer,
    MessageReducer: MessageReducer,
    ConversationReducer: ConversationReducer,
    EditDetailReducer: EditDetailReducer,
    EditAddressReducer: EditAddressReducer,
    ChatReducer: ChatReducer,
    WalletReducer: WalletReducer,
    GuestReducer: GuestReducer,
    ViewPriceReducer: ViewPriceReducer,
    FilterReducer: FilterReducer,
    TicketsReducer: TicketsReducer,
    RecommendReducer: RecommendSlice,
    OrderStatusReducer: OrderStatusReducer,
    AboutReducer: AboutReducer,
    CategoryImagesReducer: CategoryImagesReducer,
    StateLocationReducer: StateLocationReducer,
    IpAddressReducer: IpAddressReducer,
    DraftReducer: DraftReducer,
    NotificationReducer: NotificationReducer,
    PriorityReducer: PriorityReducer,
    CurrencyReducer: CurrencyReducer,
    OnGoingReducer: OnGoingReducer,
    MessageCountReducer: MessageCountReducer,
    CurrencyExchangeRateReducer: CurrencyExchangeRateReducer,
    BidsHistoryReducer: BidsHistoryReducer,
    OnGoingBidsReducer: OnGoingBidsReducer,
    unlockReducer: unlockReducer,
    viewListingPriorityReducer: viewListingPriorityReducer,    
});

const persistedReducer = persistReducer(persistConfig, rootReducer);

const store = configureStore({
    reducer: persistedReducer,
    middleware: (getDefaultMiddleware) =>
        getDefaultMiddleware({
            serializableCheck: {
                ignoredActions: [FLUSH, REHYDRATE, PAUSE, PERSIST, PURGE, REGISTER],
            },
        }),
});

export type RootState = ReturnType<typeof store.getState>;
export type AppDispatch = typeof store.dispatch;
export const persistor = persistStore(store);
export default store;
