import { createSlice } from '@reduxjs/toolkit';
import { trackOrder } from '../api/api';


interface OrderTrackingState {
  orderData: any;
  loading: boolean;
  error: string | null;
}

const initialState: OrderTrackingState = {
  orderData: null,
  loading: false,
  error: null,
};

const trackOrderSlice = createSlice({
  name: 'orderTracking',
  initialState,
  reducers: {},
  extraReducers: (builder) => {
    builder
      .addCase(trackOrder.pending, (state) => {
        state.loading = true;
        state.error = null;
      })
      .addCase(trackOrder.fulfilled, (state, action) => {
        state.loading = false;
        state.orderData = action.payload;
      })
      .addCase(trackOrder.rejected, (state, action) => {
        state.loading = false;
        state.error = action.payload as string;
      });
  },
});

export default trackOrderSlice.reducer;
