import { createSlice, PayloadAction } from "@reduxjs/toolkit";
import { addTickets, getTickets, repliesTickets, repliesTicketsId, ticketNotification } from "../api/api";


interface TicketsState {
  tickets: any;
  ticketRepliesData: any; 
  ticketsData: any;
  replies:any;
  ticketsNotificationData:any;
  loading: boolean;
  error: string | null;
}

const initialState: TicketsState = {
  tickets: [], 
  ticketRepliesData: [], 
  ticketsData:[],
  ticketsNotificationData:[],
  replies:{},
  loading: false,
  error: null,
};

const ticketsSlice = createSlice({
  name: "tickets",
  initialState,
  reducers: {},
  extraReducers: (builder) => {
    builder
      // Add Tickets
      .addCase(addTickets.pending, (state) => {
        state.loading = true;
        state.error = null;
      })
      .addCase(addTickets.fulfilled, (state, action: PayloadAction<any>) => {
        state.loading = false;
        state.tickets = action.payload; 
      })
      .addCase(addTickets.rejected, (state, action) => {
        state.loading = false;
        state.error = action.error.message|| "Failed to add tickets.";
      })

      // Get Tickets
      .addCase(getTickets.pending, (state) => {
        state.loading = true;
        state.error = null;
      })
      .addCase(getTickets.fulfilled, (state, action: PayloadAction<any>) => {
        state.loading = false;
        state.ticketsData = action.payload; 
      })
      .addCase(getTickets.rejected, (state, action) => {
        state.loading = false;
        state.error = action.error.message || "Failed to fetch tickets.";
      })

      // Replies Tickets
      .addCase(repliesTickets.pending, (state) => {
        state.loading = true;
        state.error = null;
      })
      .addCase(repliesTickets.fulfilled, (state, action: PayloadAction<any>) => {
        state.loading = false;
        console.log(".....check reply data",action.payload);
        state.ticketRepliesData = action?.payload; 
        
      })
      .addCase(repliesTickets.rejected, (state, action) => {
        state.loading = false;
        state.error = action.error.message || "Failed to fetch ticket replies.";
      })

      // Replies Tickets by ID
   
      .addCase(repliesTicketsId.pending, (state) => {
        state.loading = true;
        state.error = null;
    })
    .addCase(repliesTicketsId.fulfilled, (state, action) => {
        state.loading = false;
        console.log(action.payload)
        state.replies = action.payload;
    })
    .addCase(repliesTicketsId.rejected, (state, action) => {
        state.loading = false;
        state.error = action.error.message || 'Registration failed';
    })

    // Ticket Notification
        .addCase(ticketNotification.pending, (state) => {
        state.loading = true;
        state.error = null;
      })
      .addCase(ticketNotification.fulfilled, (state, action: PayloadAction<any>) => {
        state.loading = false;
        state.ticketsNotificationData = action.payload; 
      })
      .addCase(ticketNotification.rejected, (state, action) => {
        state.loading = false;
        state.error = action.error.message || "Failed to fetch tickets.";
      })
  },
});

export default ticketsSlice.reducer;
