import { createSlice } from "@reduxjs/toolkit";
import { stateLocation } from "../api/api"; 

interface LocationState {
  stateLocationData: any; 
  loadings: boolean;
  error: string | null;
}

const initialState: LocationState = {
  stateLocationData: [],
  loadings: false,
  error: null,
};

const locationSlice = createSlice({
  name: "location", 
  initialState,
  reducers: {},
  extraReducers: (builder) => {
    builder
      .addCase(stateLocation.pending, (state) => {
        state.loadings = true;
        state.error = null;
      })
      .addCase(stateLocation.fulfilled, (state, action) => {
        state.loadings = false;
        state.stateLocationData = action.payload;
      })
      .addCase(stateLocation.rejected, (state, action) => {
        state.loadings = false;
        state.error = action.error.message || "Failed to fetch state locations";
      });
  },
});

export default locationSlice.reducer;
