import { createSlice, PayloadAction } from "@reduxjs/toolkit";
import { priorityBids, priorityBidsData, } from "../api/api"; // Import the async thunks

interface StoreState {
  bidsData: any;
  priorityData: any;
  bidsDataUnlock: any;
  loading: boolean;
  error: string | null;
}

const initialState: StoreState = {
  bidsData: null,
  priorityData: null,
  bidsDataUnlock: [],
  loading: false,
  error: null,
};

const PriorityBids = createSlice({
  name: "store",
  initialState,
  reducers: {},
  extraReducers: (builder) => {
    // Handling storeListing API
    builder
      .addCase(priorityBids.pending, (state) => {
        state.loading = true;
      })
      .addCase(priorityBids.fulfilled, (state, action: PayloadAction<any>) => {
        state.loading = false;
        if (action.payload && Object.keys(action.payload).length > 0) {
          state.bidsData = action.payload;
        } else {
          state.bidsData = null; // clear data if empty
        }
      })
      .addCase(priorityBids.rejected, (state, action) => {
        state.loading = false;
        state.bidsData = null; // clear data on error
        state.error = action.error.message || "Failed to fetch store listing";
      })

      .addCase(priorityBidsData.pending, (state) => {
        state.loading = true;
      })
      .addCase(
        priorityBidsData.fulfilled,
        (state, action: PayloadAction<any>) => {
          state.loading = false;
          if (action.payload && Object.keys(action.payload).length > 0) {
            state.priorityData = action.payload;
          } else {
            state.priorityData = null; // clear data if empty
          }
        }
      )
      .addCase(priorityBidsData.rejected, (state, action) => {
        state.loading = false;
        state.priorityData = null; // clear data on error
        state.error = action.error.message || "Failed to fetch store listing";
      })



      ;
  },
});

export default PriorityBids.reducer;
