import { createSlice } from "@reduxjs/toolkit";
import { updateOrderStatus } from "../api/api";

interface AuctionUpdateState {
 orderUpdate: any;
  loading: boolean;
  error: string | null;
}

const initialState: AuctionUpdateState = {
    orderUpdate: null,
  loading: false,
  error: null,
};

const orderUpdateSlice = createSlice({
  name: "orderUpdate",
  initialState,
  reducers: {},
  extraReducers: (builder) => {
    builder
      .addCase(updateOrderStatus.pending, (state) => {
        state.loading = true;
        state.error = null;
      })
      .addCase(updateOrderStatus.fulfilled, (state, action) => {
        state.loading = false;
        state.orderUpdate = action.payload;
      })
      .addCase(updateOrderStatus.rejected, (state, action) => {
        state.loading = false;
        state.error = action.error.message || "Failed to update auction listing";
      });
  },
});

export default orderUpdateSlice.reducer;
