import { createSlice } from "@reduxjs/toolkit";
import { Notification, readNotification } from "../api/api";

interface ProfileState {
  notification: any;
  readNotificationData: any;
  status: "idle" | "loading" | "succeeded" | "failed";
  error: string | null;
}

const initialState: ProfileState = {
  notification: null,
  readNotificationData: null,
  status: "idle",
  error: null,
};

const notificationSlice = createSlice({
  name: "notification",
  initialState,
  reducers: {},
  extraReducers: (builder) => {
    builder
      .addCase(Notification.pending, (state) => {
        state.status = "loading";
      })
      .addCase(Notification.fulfilled, (state, action) => {
        state.status = "succeeded";
        state.notification = action.payload;
      })
      .addCase(Notification.rejected, (state, action) => {
        state.status = "failed";
        state.error =
          action.error.message || "Failed to update notification settings.";
      })

      .addCase(readNotification.pending, (state) => {
        state.status = "loading";
      })
      .addCase(readNotification.fulfilled, (state, action) => {
        state.status = "succeeded";
        state.readNotificationData = action.payload;
      })
      .addCase(readNotification.rejected, (state, action) => {
        state.status = "failed";
        state.error =
          action.error.message || "Failed to update notification settings.";
      });
  },
});

export default notificationSlice.reducer;
