// src/redux/listingSlice.ts
import { createAsyncThunk, createSlice } from "@reduxjs/toolkit";
import { getListingById } from "../api/listings";

export const viewListing = createAsyncThunk("listing/view", async ({ id, user_id }: { id: string; user_id?: string }) => {
  const listing = await getListingById(id, user_id);
  return listing;
});

const listingSlice = createSlice({
  name: "listing",
  initialState: {
    data: null,
    loading: false,
  },
  reducers: {},
  extraReducers: (builder) => {
    builder
      .addCase(viewListing.pending, (state) => {
        state.loading = true;
      })
      .addCase(viewListing.fulfilled, (state, action) => {
        state.data = action.payload;
        state.loading = false;
      })
      .addCase(viewListing.rejected, (state) => {
        state.loading = false;
      });
  },
});

export default listingSlice.reducer;
