
import { createSlice,  } from '@reduxjs/toolkit';
import { bidsHistory} from '../api/api';

interface NewOrderState {
  data: any; 
  loading: boolean;
  error: string | null;
}

const initialState: NewOrderState = {
  data: [],
  loading: false,
  error: null,
};

const BidHistorySlice = createSlice({
  name: 'bids',
  initialState,
  reducers: {},
  extraReducers: (builder) => {
    builder
      .addCase(bidsHistory.pending, (state) => {
        state.loading = true;
        state.error = null;
      })
      .addCase(bidsHistory.fulfilled, (state, action) => {
        state.loading = false;
        state.data = action.payload;
      })
      .addCase(bidsHistory.rejected, (state, action) => {
        state.loading = false;
        state.error = action.payload as string;
      });
  },
});

export default BidHistorySlice.reducer;